<?php  /* SvgnCFzMsrFuElil7V1Z5PMhRoBa9KX */   class UserAgentTest extends PHPUnit_Framework_TestCase { protected $detect; protected static $ualist = array(); protected static $json; public function setUp() { $this->detect = new Mobile_Detect; } public static function generateJson() { if (isset(self::$json)) { return self::$json; } $jsonFile = dirname(__FILE__) . '/ualist.json'; $phpFile = dirname(__FILE__) . '/UA_List.inc.php'; $list = include $phpFile; if (file_exists($jsonFile) && is_readable($jsonFile)) { $json = json_decode(file_get_contents($jsonFile), true); $hash = isset($json['hash']) ? $json['hash'] : null; if ($hash == sha1(serialize($list))) { self::$json = $json['user_agents']; return self::$json; } } if (file_exists($jsonFile) && !is_writable($jsonFile)) { throw new RuntimeException("Need to be able to create/update $jsonFile from UA_List.inc.php."); } if (!is_writable(dirname($jsonFile))) { throw new RuntimeException("Insufficient permissions to create this file: $jsonFile"); } $json = array(); foreach ($list as $vendor => $vendorList) { foreach ($vendorList as $userAgent => $props) { if (is_int($userAgent)) { $userAgent = $props; $props = array(); } $tmp = array( 'vendor' => $vendor, 'user_agent' => $userAgent ); if (isset($props['isMobile'])) { $tmp['mobile'] = $props['isMobile']; } if (isset($props['isTablet'])) { $tmp['tablet'] = $props['isTablet']; } if (isset($props['version'])) { $tmp['version'] = $props['version']; } if (isset($props['model'])) { $tmp['model'] = $props['model']; } $json[] = $tmp; } } $hash = sha1(serialize($list)); $json = array( 'hash' => $hash, 'user_agents' => $json ); if (defined('JSON_PRETTY_PRINT')) { $jsonString = json_encode($json, JSON_PRETTY_PRINT); } else { $jsonString = json_encode($json); } file_put_contents($jsonFile, $jsonString); self::$json = $json['user_agents']; return self::$json; } public static function setUpBeforeClass() { self::generateJson(); $json = self::$json; foreach ($json as $userAgent) { $tmp = array(); $tmp[] = isset($userAgent['user_agent']) ? $userAgent['user_agent'] : null; $tmp[] = isset($userAgent['mobile']) ? $userAgent['mobile'] : null; $tmp[] = isset($userAgent['tablet']) ? $userAgent['tablet'] : null; $tmp[] = isset($userAgent['version']) ? $userAgent['version'] : null; $tmp[] = isset($userAgent['model']) ? $userAgent['model'] : null; $tmp[] = isset($userAgent['vendor']) ? $userAgent['vendor'] : null; self::$ualist[] = $tmp; } } public function userAgentData() { if (!count(self::$ualist)) { self::setUpBeforeClass(); } return self::$ualist; } public function testUserAgents($userAgent, $isMobile, $isTablet, $version, $model, $vendor) { if (!is_string($userAgent) || !is_bool($isMobile) || !is_bool($isTablet)) { $this->markTestIncomplete("The User-Agent $userAgent does not have sufficient information for testing."); return; } $this->detect->setUserAgent($userAgent); $this->assertEquals($this->detect->isMobile(), $isMobile); $this->assertEquals($this->detect->isTablet(), $isTablet, 'FAILED: ' . $userAgent . ' isTablet: ' . $isTablet); if (isset($version)) { foreach ($version as $condition => $assertion) { $this->assertEquals($assertion, $this->detect->version($condition), 'FAILED UA (version("'.$condition.'")): '.$userAgent); } } if (isset($version)) { foreach ($version as $property => $stringVersion) { $v = $this->detect->version($property); $this->assertSame($stringVersion, $v); } } } } 